//Knowledgedump.org - Implementation of a class containing a numeric value with measuring error.

#ifndef MEASURING_ERROR_H	//Include guard
#define MEASURING_ERROR_H

#include <iostream>
#include <cmath>			//For sqrt and pow functions.


class ErrVal {
public:
	ErrVal(double value, double error);	//Constructor with value and (absolute) measuring error.
	double value() const;				//Returns element value.
	double abs_err() const;				//Returns absolute error.
	double rel_err() const;				//Returns relative error err/val.
	ErrVal operator+(const ErrVal& ev);	//Summation of two values with measuring error.
	ErrVal operator*(const ErrVal& ev);
private:
	double val;							//Numeric value as double.
	double err;							//Absolute measuring error.
};


//Constructor
ErrVal::ErrVal(double value, double error) {
	val = value; err = error;
}

//Return value
double ErrVal::value() const {
	return val;
}

//Return absolute measuring error
double ErrVal::abs_err() const {
	return err;
}

//Return relative measuring error
double ErrVal::rel_err() const {
	return err / val;
}

//Summation of two values with measuring error
ErrVal ErrVal::operator+(const ErrVal& ev) {
	ErrVal out(0, 0);
	out.val = val + ev.val;
	out.err = std::sqrt(std::pow(abs_err(), 2.0) + std::pow(ev.abs_err(), 2.0));
	return out;
}

//Product of two values with measuring error
ErrVal ErrVal::operator*(const ErrVal& ev) {
	ErrVal out(0, 0);
	out.val = val * ev.val;
	out.err = std::sqrt(std::pow(rel_err(), 2.0) + std::pow(ev.rel_err(), 2.0)) * out.val;
	return out;
}



#endif		//Include guard