//Knowledgedump.org - Function that runs a fermat test, in order to detect, whether a number is prime.
//Works for numbers up to about 3*10^9.

#ifndef MEASURING_ERROR_H	//Include guard
#define MEASURING_ERROR_H

#include <iostream>
#include <cstdlib>			//For RNG functions rand and srand
#include <ctime>			//For RNG seed time(0)
#include "modular_exp.h"	//For pow


//n is the number to check for being prime and k is the amount of runs.
//long long chosen for allowance of larger numbers, and compatibility with modular_exp().
bool fermat_test(long long n, long long k) {
	if (n <= 1) {
		std::cout << "Number too small." << std::endl;
		return false;
	}
	if ((n == 2) || (n == 3)) {
		std::cout << n << " is prime." << std::endl;
		return true;
	}
	if (k <= 0) {
		std::cout << "Invalid amount of runs." << std::endl;
		return false;
	}

	//Pick "random" seed.
	std::srand(time(0));	//time(0) is the time difference between current time and 00:00, 01-01-1970 UTC in seconds.
	long long a = 1;

	while (k > 0) {
		a = (std::rand() % (n - 3)) + 2;				//a is random number between 2 and max(n-2, RAND_MAX+2).
		if (modular_exp(a, n-1, n) != (1 % n)) {		//modular_exp() instead of pow(), to avoid integer overflow.
			std::cout << n << " is not prime." << std::endl;
			return false; 
		}
		--k;
	}
	std::cout << n << " is likely prime." << std::endl;
	return true;
}



#endif		//Include guard