"""
    Knowledgedump.org - Image Classification - visualize_results
    Function for visualizing results after training and testing the CNN model on CIFAR-10 image classification.

    Required packages: matplotlib
"""

import matplotlib.pyplot as pypl

# Input: Lists of training loss values and accuracy % for both the training and testing set.
def plot_results(train_losses, train_accuracies, test_accuracies):
    pypl.figure(figsize=(12, 4))

    # Plot training loss:
    pypl.subplot(1, 2, 1)
    pypl.plot(train_losses, label='Train Loss')
    pypl.title('Training Loss over Epochs')
    pypl.xlabel('Epoch')
    pypl.ylabel('Loss')
    pypl.legend()

    # Plot training and testing accuracy:
    pypl.subplot(1, 2, 2)
    pypl.plot(train_accuracies, label='Train Accuracy')
    pypl.plot(test_accuracies, label='Test Accuracy')
    pypl.title('Training and Test Accuracy over Epochs')
    pypl.xlabel('Epoch')
    pypl.ylabel('Accuracy (%)')
    pypl.legend()

    pypl.tight_layout()
    pypl.show()