#Knowledgedump.org - Analyse der ”hills“-Daten aus dem Paket ”MASS “


#1) Laden & allgemeine Betrachtung der Daten

library(MASS)
hills			#Fuer ersten Blick auf die Daten..
help(hills)		#Informationen zu den Attributen/Datenmenge


str(hills)		#Liefert kurzen Ueberblick
summary(hills)	#Liefert grobe Zusammenfassung der Attributwerte


oldpar <- par(mfrow=c(1,2))
plot(hills$time,hills$dist,xlab="Bestzeit in Minuten",
ylab="Distanz in Meilen",main="Zeit gg. Distanz")

plot(hills$time,hills$climb,xlab="Bestzeit in Minuten",
ylab="Anstieg in Fuss",main="Zeit gg. Anstieg")


#2. Lineare Regression

lmhills <- lm( time ~ dist + climb, data = hills)	#definieren des Objekts der Klasse "lm"
summary(lmhills)

par(mfrow=c(1,1))
plot(lmhills, which =1) 

rownames(hills)
hills[18,]

hills2<-hills
hills2[18,3] <- 18.65
lmhills2 <- lm( time ~ dist + climb, data = hills2)
lmhills2
plot(lmhills2, which =1)

hills[7,]

par(mfrow=c(1,1))
plot(lmhills2, which =1)

leverage<-hatvalues(lmhills2)
leverage

stdresiduals<- stdres(lmhills2)
par(mfrow=c(1,2))
plot(leverage,stdresiduals,xlab="standardisierte Residuen",
ylab="Hebelgewicht",main="Hebelgewicht gg. Residuen")
plot(lmhills2, which=5)

par(mfrow=c(1,1))
rstud<-rstudent(lmhills2)
rstud
plot(rstudent(lmhills2))
text(7,rstud[7],rownames(hills)[7],pos=1)

par(mfrow=c(1,2))
dff<-dffits(lmhills2)
dff
plot(dff)
text(7,dff[7],rownames(hills)[7],pos=1)
cooks<-cooks.distance(lmhills2)
cooks
plot(cooks)
text(7,cooks[7],rownames(hills)[7],pos=1)

par(mfrow=c(2,2))
hills3<-hills2[-7,]
lmhills3<-lm(time ~ dist + climb, data = hills3)
summary(lmhills3)
plot(lmhills2, which=c(1,5))
plot(lmhills3, which=c(1,5))

par(mfrow=c(1,1))
plot(hatvalues(lmhills3), main="Hebelgewichte nach Index",
ylab="Hebelgewicht", xlab="Index")
identify(hatvalues(lmhills3))

plot(residuals(lmhills3), main="Residuen nach Index",
ylab="Residuum", xlab="Index")
identify(residuals(lmhills3))
