#Knowledgedump.org - Vergleich verschiedener linearer Regressionsmodelle fuer die "hills"-Daten:
#	time ~ 1
#	time ~ 1 + dist
#	time ~ 1 + dist + climb


#1 Visualisierung der Modelleigenschaften

library(MASS)
#source("C:\\..............\\plot.lm2.R")
##plot.lm2 laden!

lm1<-lm(time~1, data=hills, y=TRUE)
lm1d<-lm(time~1+dist, data=hills, y=TRUE)
lm1dc<-lm(time~1+dist+climb, data=hills,y=TRUE)

summary(lm1)
summary(lm1d)
summary(lm1dc)

par(mfrow=c(1,2))
plot.lm2(lm1, which=1:2)


par(mfrow=c(1,3))
plot.lm2(lm1,which=1)
plot.lm2(lm1d,which=1)
plot.lm2(lm1dc,which=1)

par(mfrow=c(1,3))
plot.lm2(lm1,which=2)
plot.lm2(lm1d,which=2)
plot.lm2(lm1dc,which=2)

par(mfrow=c(1,3))
plot.lm2(lm1,which=3)
plot.lm2(lm1d,which=3)
plot.lm2(lm1dc,which=3)

par(mfrow=c(1,3))
plot.lm2(lm1,which=4)
plot.lm2(lm1d,which=4)
plot.lm2(lm1dc,which=4)

par(mfrow=c(1,3))
plot.lm2(lm1,which=5)	##Alle Hutwerte identisch -> kein plot
plot.lm2(lm1d,which=5)
plot.lm2(lm1dc,which=5)

par(mfrow=c(1,3))
plot.lm2(lm1,which=6)
plot.lm2(lm1d,which=6)
plot.lm2(lm1dc,which=6)

par(mfrow=c(1,3))
plot.lm2(lm1,which=7)	##Ranked Fit - Vorsicht Rundungsfehler!
plot.lm2(lm1d,which=7)
plot.lm2(lm1dc,which=7)

par(mfrow=c(1,3))
plot.lm2(lm1,which=7, rank.type="response")
plot.lm2(lm1d,which=7, rank.type="response")
plot.lm2(lm1dc,which=7, rank.type="response")

par(mfrow=c(1,2))
plot(rank(hills[,2]),studres(lm1d), xlab="ranked climb", ylab="Stud. Res.", main="Stud. Res. gg. ranked climb", sub="Modell lm1d")
panel.smooth(rank(hills[,2]),studres(lm1d))
plot(rank(hills[,2]),studres(lm1dc), xlab="ranked climb", ylab="Stud. Res.", main="Stud. Res. gg. ranked climb", sub="Modell lm1dc")
panel.smooth(rank(hills[,2]),studres(lm1dc))


#2 Modellwahl mit Hilfe von Varianzanalyse (ANOVA)


anova(lm1dc)


#3 Modellwahl mit Schrittweiser Orthogonalzerlegung

#lm1 offensichtlich dem Modell lm1d unterlegen -> was ist mit lm1d gg. 1m1dc?

par(mfrow=c(1,1))
lmc.d<-lm(climb~dist, data=hills)
plot(hills$dist, hills$climb, xlab="Distanz",ylab="Anstieg", main="Distanz vs. Anstieg")
abline(lmc.d)

lm1d.orth<-lm(lm1d$residuals ~ 0 + lmc.d$residuals, data=hills) 	#Orthokomplement zu lm1d
summary(lm1d.orth)

